package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceSliceList is a collection of ResourceSlices. */
final case class ResourceSliceList(
  items : Seq[io.k8s.api.resource.v1alpha3.ResourceSlice],
  listMeta : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceSliceList", "v1alpha3")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha3.ResourceSlice]) : ResourceSliceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha3.ResourceSlice*) : ResourceSliceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha3.ResourceSlice] => Seq[io.k8s.api.resource.v1alpha3.ResourceSlice]) : ResourceSliceList = copy(items = f(items))

  /** Returns a new data with listMeta set to new value */
  def withListMeta(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceSliceList = copy(listMeta = Some(value))
  /** if listMeta has a value, transforms to the result of function*/
  def mapListMeta(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceSliceList = copy(listMeta = listMeta.map(f))

  override def foldTo[T : Builder] : T = ResourceSliceList.encoder.apply(this)
}

object ResourceSliceList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.ResourceSliceList] = new Encoder[io.k8s.api.resource.v1alpha3.ResourceSliceList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.ResourceSliceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("listMeta", o.listMeta)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceSliceList] = new Decoder[ResourceSliceList] {
      def apply[T : Reader](t: T): Either[String, ResourceSliceList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha3.ResourceSlice]]("items")
          listMeta <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("listMeta")
      } yield ResourceSliceList (
          items = items,
          listMeta = listMeta
        )
    }
}

