package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver. A pool may span more than one ResourceSlice, and exactly how many ResourceSlices comprise a pool is determined by the driver.

At the moment, the only supported resources are devices with attributes and capacities. Each device in a given pool, regardless of how many ResourceSlices, must have a unique name. The ResourceSlice in which a device gets published may change over time. The unique identifier for a device is the tuple <driver name>, <pool name>, <device name>.

Whenever a driver needs to update a pool, it increments the pool.Spec.Pool.Generation number and updates all ResourceSlices with that new number and new resource definitions. A consumer must only use ResourceSlices with the highest generation number and ignore all others.

When allocating all resources in a pool matching certain criteria or when looking for the best solution among several different alternatives, a consumer should check the number of ResourceSlices in a pool (included in each ResourceSlice) to determine whether its view of a pool is complete and if not, should wait until the driver has completed updating the pool.

For resources that are not local to a node, the node name is not set. Instead, the driver may use a node selector to specify where the devices are available.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class ResourceSlice(
  spec : io.k8s.api.resource.v1alpha3.ResourceSliceSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceSlice", "v1alpha3")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha3.ResourceSliceSpec) : ResourceSlice = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha3.ResourceSliceSpec => io.k8s.api.resource.v1alpha3.ResourceSliceSpec) : ResourceSlice = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceSlice = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceSlice = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceSlice.encoder.apply(this)
}

object ResourceSlice {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.ResourceSlice] = new Encoder[io.k8s.api.resource.v1alpha3.ResourceSlice] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.ResourceSlice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceSlice] = new Decoder[ResourceSlice] {
      def apply[T : Reader](t: T): Either[String, ResourceSlice] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha3.ResourceSliceSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceSlice (
          spec = spec,
          metadata = metadata
        )
    }
}

