package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** ResourcePool describes the pool that ResourceSlices belong to. */
final case class ResourcePool(
  generation : Long,
  name : String,
  resourceSliceCount : Long
) {

  /** Returns a new data with generation set to new value */
  def withGeneration(value: Long) : ResourcePool = copy(generation = value)
  /** transforms generation to result of function */
  def mapGeneration(f: Long => Long) : ResourcePool = copy(generation = f(generation))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourcePool = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourcePool = copy(name = f(name))

  /** Returns a new data with resourceSliceCount set to new value */
  def withResourceSliceCount(value: Long) : ResourcePool = copy(resourceSliceCount = value)
  /** transforms resourceSliceCount to result of function */
  def mapResourceSliceCount(f: Long => Long) : ResourcePool = copy(resourceSliceCount = f(resourceSliceCount))
}

object ResourcePool {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.ResourcePool] = new Encoder[io.k8s.api.resource.v1alpha3.ResourcePool] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.ResourcePool) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("generation", o.generation)
            .write("name", o.name)
            .write("resourceSliceCount", o.resourceSliceCount)
            .build
        }
    }

    implicit val decoder: Decoder[ResourcePool] = new Decoder[ResourcePool] {
      def apply[T : Reader](t: T): Either[String, ResourcePool] = for {
          obj <- ObjectReader(t)
          generation <- obj.read[Long]("generation")
          name <- obj.read[String]("name")
          resourceSliceCount <- obj.read[Long]("resourceSliceCount")
      } yield ResourcePool (
          generation = generation,
          name = name,
          resourceSliceCount = resourceSliceCount
        )
    }
}

