package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it. */
final case class ResourceClaimSpec(
  controller : Option[String] = None,
  devices : Option[io.k8s.api.resource.v1alpha3.DeviceClaim] = None
) {

  /** Returns a new data with controller set to new value */
  def withController(value: String) : ResourceClaimSpec = copy(controller = Some(value))
  /** if controller has a value, transforms to the result of function*/
  def mapController(f: String => String) : ResourceClaimSpec = copy(controller = controller.map(f))

  /** Returns a new data with devices set to new value */
  def withDevices(value: io.k8s.api.resource.v1alpha3.DeviceClaim) : ResourceClaimSpec = copy(devices = Some(value))
  /** if devices has a value, transforms to the result of function*/
  def mapDevices(f: io.k8s.api.resource.v1alpha3.DeviceClaim => io.k8s.api.resource.v1alpha3.DeviceClaim) : ResourceClaimSpec = copy(devices = devices.map(f))
}

object ResourceClaimSpec {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.ResourceClaimSpec] = new Encoder[io.k8s.api.resource.v1alpha3.ResourceClaimSpec] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.ResourceClaimSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("controller", o.controller)
            .write("devices", o.devices)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimSpec] = new Decoder[ResourceClaimSpec] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimSpec] = for {
          obj <- ObjectReader(t)
          controller <- obj.readOpt[String]("controller")
          devices <- obj.readOpt[io.k8s.api.resource.v1alpha3.DeviceClaim]("devices")
      } yield ResourceClaimSpec (
          controller = controller,
          devices = devices
        )
    }
}

