package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class ResourceClaim(
  spec : io.k8s.api.resource.v1alpha3.ResourceClaimSpec,
  status : Option[io.k8s.api.resource.v1alpha3.ResourceClaimStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClaim", "v1alpha3")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha3.ResourceClaimSpec) : ResourceClaim = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha3.ResourceClaimSpec => io.k8s.api.resource.v1alpha3.ResourceClaimSpec) : ResourceClaim = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.resource.v1alpha3.ResourceClaimStatus) : ResourceClaim = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.resource.v1alpha3.ResourceClaimStatus => io.k8s.api.resource.v1alpha3.ResourceClaimStatus) : ResourceClaim = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaim = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaim = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClaim.encoder.apply(this)
}

object ResourceClaim {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.ResourceClaim] = new Encoder[io.k8s.api.resource.v1alpha3.ResourceClaim] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.ResourceClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaim] = new Decoder[ResourceClaim] {
      def apply[T : Reader](t: T): Either[String, ResourceClaim] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha3.ResourceClaimSpec]("spec")
          status <- obj.readOpt[io.k8s.api.resource.v1alpha3.ResourceClaimStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceClaim (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

