package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** PodSchedulingContextSpec describes where resources for the Pod are needed. */
final case class PodSchedulingContextSpec(
  potentialNodes : Option[Seq[String]] = None,
  selectedNode : Option[String] = None
) {

  /** Returns a new data with potentialNodes set to new value */
  def withPotentialNodes(value: Seq[String]) : PodSchedulingContextSpec = copy(potentialNodes = Some(value))
  /** Appends new values to potentialNodes */
  def addPotentialNodes(newValues: String*) : PodSchedulingContextSpec = copy(potentialNodes = Some(potentialNodes.fold(newValues)(_ ++ newValues)))
  /** if potentialNodes has a value, transforms to the result of function*/
  def mapPotentialNodes(f: Seq[String] => Seq[String]) : PodSchedulingContextSpec = copy(potentialNodes = potentialNodes.map(f))

  /** Returns a new data with selectedNode set to new value */
  def withSelectedNode(value: String) : PodSchedulingContextSpec = copy(selectedNode = Some(value))
  /** if selectedNode has a value, transforms to the result of function*/
  def mapSelectedNode(f: String => String) : PodSchedulingContextSpec = copy(selectedNode = selectedNode.map(f))
}

object PodSchedulingContextSpec {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.PodSchedulingContextSpec] = new Encoder[io.k8s.api.resource.v1alpha3.PodSchedulingContextSpec] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.PodSchedulingContextSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("potentialNodes", o.potentialNodes)
            .write("selectedNode", o.selectedNode)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingContextSpec] = new Decoder[PodSchedulingContextSpec] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingContextSpec] = for {
          obj <- ObjectReader(t)
          potentialNodes <- obj.readOpt[Seq[String]]("potentialNodes")
          selectedNode <- obj.readOpt[String]("selectedNode")
      } yield PodSchedulingContextSpec (
          potentialNodes = potentialNodes,
          selectedNode = selectedNode
        )
    }
}

