package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor. */
final case class OpaqueDeviceConfiguration(
  driver : String,
  parameters : io.k8s.apimachinery.pkg.runtime.RawExtension
) {

  /** Returns a new data with driver set to new value */
  def withDriver(value: String) : OpaqueDeviceConfiguration = copy(driver = value)
  /** transforms driver to result of function */
  def mapDriver(f: String => String) : OpaqueDeviceConfiguration = copy(driver = f(driver))

  /** Returns a new data with parameters set to new value */
  def withParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : OpaqueDeviceConfiguration = copy(parameters = value)
  /** transforms parameters to result of function */
  def mapParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : OpaqueDeviceConfiguration = copy(parameters = f(parameters))
}

object OpaqueDeviceConfiguration {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration] = new Encoder[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driver", o.driver)
            .write("parameters", o.parameters)
            .build
        }
    }

    implicit val decoder: Decoder[OpaqueDeviceConfiguration] = new Decoder[OpaqueDeviceConfiguration] {
      def apply[T : Reader](t: T): Either[String, OpaqueDeviceConfiguration] = for {
          obj <- ObjectReader(t)
          driver <- obj.read[String]("driver")
          parameters <- obj.read[io.k8s.apimachinery.pkg.runtime.RawExtension]("parameters")
      } yield OpaqueDeviceConfiguration (
          driver = driver,
          parameters = parameters
        )
    }
}

