package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceSelector must have exactly one field set. */
final case class DeviceSelector(
  cel : Option[io.k8s.api.resource.v1alpha3.CELDeviceSelector] = None
) {

  /** Returns a new data with cel set to new value */
  def withCel(value: io.k8s.api.resource.v1alpha3.CELDeviceSelector) : DeviceSelector = copy(cel = Some(value))
  /** if cel has a value, transforms to the result of function*/
  def mapCel(f: io.k8s.api.resource.v1alpha3.CELDeviceSelector => io.k8s.api.resource.v1alpha3.CELDeviceSelector) : DeviceSelector = copy(cel = cel.map(f))
}

object DeviceSelector {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceSelector] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceSelector] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("cel", o.cel)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceSelector] = new Decoder[DeviceSelector] {
      def apply[T : Reader](t: T): Either[String, DeviceSelector] = for {
          obj <- ObjectReader(t)
          cel <- obj.readOpt[io.k8s.api.resource.v1alpha3.CELDeviceSelector]("cel")
      } yield DeviceSelector (
          cel = cel
        )
    }
}

