package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceRequestAllocationResult contains the allocation result for one request. */
final case class DeviceRequestAllocationResult(
  device : String,
  driver : String,
  pool : String,
  request : String
) {

  /** Returns a new data with device set to new value */
  def withDevice(value: String) : DeviceRequestAllocationResult = copy(device = value)
  /** transforms device to result of function */
  def mapDevice(f: String => String) : DeviceRequestAllocationResult = copy(device = f(device))

  /** Returns a new data with driver set to new value */
  def withDriver(value: String) : DeviceRequestAllocationResult = copy(driver = value)
  /** transforms driver to result of function */
  def mapDriver(f: String => String) : DeviceRequestAllocationResult = copy(driver = f(driver))

  /** Returns a new data with pool set to new value */
  def withPool(value: String) : DeviceRequestAllocationResult = copy(pool = value)
  /** transforms pool to result of function */
  def mapPool(f: String => String) : DeviceRequestAllocationResult = copy(pool = f(pool))

  /** Returns a new data with request set to new value */
  def withRequest(value: String) : DeviceRequestAllocationResult = copy(request = value)
  /** transforms request to result of function */
  def mapRequest(f: String => String) : DeviceRequestAllocationResult = copy(request = f(request))
}

object DeviceRequestAllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("device", o.device)
            .write("driver", o.driver)
            .write("pool", o.pool)
            .write("request", o.request)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceRequestAllocationResult] = new Decoder[DeviceRequestAllocationResult] {
      def apply[T : Reader](t: T): Either[String, DeviceRequestAllocationResult] = for {
          obj <- ObjectReader(t)
          device <- obj.read[String]("device")
          driver <- obj.read[String]("driver")
          pool <- obj.read[String]("pool")
          request <- obj.read[String]("request")
      } yield DeviceRequestAllocationResult (
          device = device,
          driver = driver,
          pool = pool,
          request = request
        )
    }
}

