package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceConstraint must have exactly one field set besides Requests. */
final case class DeviceConstraint(
  matchAttribute : Option[String] = None,
  requests : Option[Seq[String]] = None
) {

  /** Returns a new data with matchAttribute set to new value */
  def withMatchAttribute(value: String) : DeviceConstraint = copy(matchAttribute = Some(value))
  /** if matchAttribute has a value, transforms to the result of function*/
  def mapMatchAttribute(f: String => String) : DeviceConstraint = copy(matchAttribute = matchAttribute.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Seq[String]) : DeviceConstraint = copy(requests = Some(value))
  /** Appends new values to requests */
  def addRequests(newValues: String*) : DeviceConstraint = copy(requests = Some(requests.fold(newValues)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Seq[String] => Seq[String]) : DeviceConstraint = copy(requests = requests.map(f))
}

object DeviceConstraint {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceConstraint] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceConstraint] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceConstraint) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchAttribute", o.matchAttribute)
            .write("requests", o.requests)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceConstraint] = new Decoder[DeviceConstraint] {
      def apply[T : Reader](t: T): Either[String, DeviceConstraint] = for {
          obj <- ObjectReader(t)
          matchAttribute <- obj.readOpt[String]("matchAttribute")
          requests <- obj.readOpt[Seq[String]]("requests")
      } yield DeviceConstraint (
          matchAttribute = matchAttribute,
          requests = requests
        )
    }
}

