package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it. */
final case class DeviceClassSpec(
  config : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration]] = None,
  selectors : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceSelector]] = None,
  suitableNodes : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with config set to new value */
  def withConfig(value: Seq[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration]) : DeviceClassSpec = copy(config = Some(value))
  /** Appends new values to config */
  def addConfig(newValues: io.k8s.api.resource.v1alpha3.DeviceClassConfiguration*) : DeviceClassSpec = copy(config = Some(config.fold(newValues)(_ ++ newValues)))
  /** if config has a value, transforms to the result of function*/
  def mapConfig(f: Seq[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration] => Seq[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration]) : DeviceClassSpec = copy(config = config.map(f))

  /** Returns a new data with selectors set to new value */
  def withSelectors(value: Seq[io.k8s.api.resource.v1alpha3.DeviceSelector]) : DeviceClassSpec = copy(selectors = Some(value))
  /** Appends new values to selectors */
  def addSelectors(newValues: io.k8s.api.resource.v1alpha3.DeviceSelector*) : DeviceClassSpec = copy(selectors = Some(selectors.fold(newValues)(_ ++ newValues)))
  /** if selectors has a value, transforms to the result of function*/
  def mapSelectors(f: Seq[io.k8s.api.resource.v1alpha3.DeviceSelector] => Seq[io.k8s.api.resource.v1alpha3.DeviceSelector]) : DeviceClassSpec = copy(selectors = selectors.map(f))

  /** Returns a new data with suitableNodes set to new value */
  def withSuitableNodes(value: io.k8s.api.core.v1.NodeSelector) : DeviceClassSpec = copy(suitableNodes = Some(value))
  /** if suitableNodes has a value, transforms to the result of function*/
  def mapSuitableNodes(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : DeviceClassSpec = copy(suitableNodes = suitableNodes.map(f))
}

object DeviceClassSpec {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceClassSpec] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceClassSpec] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceClassSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("config", o.config)
            .write("selectors", o.selectors)
            .write("suitableNodes", o.suitableNodes)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceClassSpec] = new Decoder[DeviceClassSpec] {
      def apply[T : Reader](t: T): Either[String, DeviceClassSpec] = for {
          obj <- ObjectReader(t)
          config <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration]]("config")
          selectors <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceSelector]]("selectors")
          suitableNodes <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("suitableNodes")
      } yield DeviceClassSpec (
          config = config,
          selectors = selectors,
          suitableNodes = suitableNodes
        )
    }
}

