package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceClassConfiguration is used in DeviceClass. */
final case class DeviceClassConfiguration(
  opaque : Option[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration] = None
) {

  /** Returns a new data with opaque set to new value */
  def withOpaque(value: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceClassConfiguration = copy(opaque = Some(value))
  /** if opaque has a value, transforms to the result of function*/
  def mapOpaque(f: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration => io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceClassConfiguration = copy(opaque = opaque.map(f))
}

object DeviceClassConfiguration {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceClassConfiguration] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceClassConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("opaque", o.opaque)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceClassConfiguration] = new Decoder[DeviceClassConfiguration] {
      def apply[T : Reader](t: T): Either[String, DeviceClassConfiguration] = for {
          obj <- ObjectReader(t)
          opaque <- obj.readOpt[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration]("opaque")
      } yield DeviceClassConfiguration (
          opaque = opaque
        )
    }
}

