package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class DeviceClass(
  spec : io.k8s.api.resource.v1alpha3.DeviceClassSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "DeviceClass", "v1alpha3")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha3.DeviceClassSpec) : DeviceClass = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha3.DeviceClassSpec => io.k8s.api.resource.v1alpha3.DeviceClassSpec) : DeviceClass = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : DeviceClass = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : DeviceClass = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = DeviceClass.encoder.apply(this)
}

object DeviceClass {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceClass] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceClass] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceClass) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceClass] = new Decoder[DeviceClass] {
      def apply[T : Reader](t: T): Either[String, DeviceClass] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha3.DeviceClassSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield DeviceClass (
          spec = spec,
          metadata = metadata
        )
    }
}

