package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceClaimConfiguration is used for configuration parameters in DeviceClaim. */
final case class DeviceClaimConfiguration(
  opaque : Option[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration] = None,
  requests : Option[Seq[String]] = None
) {

  /** Returns a new data with opaque set to new value */
  def withOpaque(value: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceClaimConfiguration = copy(opaque = Some(value))
  /** if opaque has a value, transforms to the result of function*/
  def mapOpaque(f: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration => io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceClaimConfiguration = copy(opaque = opaque.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Seq[String]) : DeviceClaimConfiguration = copy(requests = Some(value))
  /** Appends new values to requests */
  def addRequests(newValues: String*) : DeviceClaimConfiguration = copy(requests = Some(requests.fold(newValues)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Seq[String] => Seq[String]) : DeviceClaimConfiguration = copy(requests = requests.map(f))
}

object DeviceClaimConfiguration {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("opaque", o.opaque)
            .write("requests", o.requests)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceClaimConfiguration] = new Decoder[DeviceClaimConfiguration] {
      def apply[T : Reader](t: T): Either[String, DeviceClaimConfiguration] = for {
          obj <- ObjectReader(t)
          opaque <- obj.readOpt[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration]("opaque")
          requests <- obj.readOpt[Seq[String]]("requests")
      } yield DeviceClaimConfiguration (
          opaque = opaque,
          requests = requests
        )
    }
}

