package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceClaim defines how to request devices with a ResourceClaim. */
final case class DeviceClaim(
  config : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration]] = None,
  constraints : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceConstraint]] = None,
  requests : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceRequest]] = None
) {

  /** Returns a new data with config set to new value */
  def withConfig(value: Seq[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration]) : DeviceClaim = copy(config = Some(value))
  /** Appends new values to config */
  def addConfig(newValues: io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration*) : DeviceClaim = copy(config = Some(config.fold(newValues)(_ ++ newValues)))
  /** if config has a value, transforms to the result of function*/
  def mapConfig(f: Seq[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration] => Seq[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration]) : DeviceClaim = copy(config = config.map(f))

  /** Returns a new data with constraints set to new value */
  def withConstraints(value: Seq[io.k8s.api.resource.v1alpha3.DeviceConstraint]) : DeviceClaim = copy(constraints = Some(value))
  /** Appends new values to constraints */
  def addConstraints(newValues: io.k8s.api.resource.v1alpha3.DeviceConstraint*) : DeviceClaim = copy(constraints = Some(constraints.fold(newValues)(_ ++ newValues)))
  /** if constraints has a value, transforms to the result of function*/
  def mapConstraints(f: Seq[io.k8s.api.resource.v1alpha3.DeviceConstraint] => Seq[io.k8s.api.resource.v1alpha3.DeviceConstraint]) : DeviceClaim = copy(constraints = constraints.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Seq[io.k8s.api.resource.v1alpha3.DeviceRequest]) : DeviceClaim = copy(requests = Some(value))
  /** Appends new values to requests */
  def addRequests(newValues: io.k8s.api.resource.v1alpha3.DeviceRequest*) : DeviceClaim = copy(requests = Some(requests.fold(newValues)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Seq[io.k8s.api.resource.v1alpha3.DeviceRequest] => Seq[io.k8s.api.resource.v1alpha3.DeviceRequest]) : DeviceClaim = copy(requests = requests.map(f))
}

object DeviceClaim {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceClaim] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceClaim] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("config", o.config)
            .write("constraints", o.constraints)
            .write("requests", o.requests)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceClaim] = new Decoder[DeviceClaim] {
      def apply[T : Reader](t: T): Either[String, DeviceClaim] = for {
          obj <- ObjectReader(t)
          config <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceClaimConfiguration]]("config")
          constraints <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceConstraint]]("constraints")
          requests <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceRequest]]("requests")
      } yield DeviceClaim (
          config = config,
          constraints = constraints,
          requests = requests
        )
    }
}

