package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceAttribute must have exactly one field set. */
final case class DeviceAttribute(
  bool : Option[Boolean] = None,
  int : Option[Long] = None,
  string : Option[String] = None,
  version : Option[String] = None
) {

  /** Returns a new data with bool set to new value */
  def withBool(value: Boolean) : DeviceAttribute = copy(bool = Some(value))
  /** if bool has a value, transforms to the result of function*/
  def mapBool(f: Boolean => Boolean) : DeviceAttribute = copy(bool = bool.map(f))

  /** Returns a new data with int set to new value */
  def withInt(value: Long) : DeviceAttribute = copy(int = Some(value))
  /** if int has a value, transforms to the result of function*/
  def mapInt(f: Long => Long) : DeviceAttribute = copy(int = int.map(f))

  /** Returns a new data with string set to new value */
  def withString(value: String) : DeviceAttribute = copy(string = Some(value))
  /** if string has a value, transforms to the result of function*/
  def mapString(f: String => String) : DeviceAttribute = copy(string = string.map(f))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : DeviceAttribute = copy(version = Some(value))
  /** if version has a value, transforms to the result of function*/
  def mapVersion(f: String => String) : DeviceAttribute = copy(version = version.map(f))
}

object DeviceAttribute {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceAttribute] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceAttribute] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceAttribute) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("bool", o.bool)
            .write("int", o.int)
            .write("string", o.string)
            .write("version", o.version)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceAttribute] = new Decoder[DeviceAttribute] {
      def apply[T : Reader](t: T): Either[String, DeviceAttribute] = for {
          obj <- ObjectReader(t)
          bool <- obj.readOpt[Boolean]("bool")
          int <- obj.readOpt[Long]("int")
          string <- obj.readOpt[String]("string")
          version <- obj.readOpt[String]("version")
      } yield DeviceAttribute (
          bool = bool,
          int = int,
          string = string,
          version = version
        )
    }
}

