package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceAllocationResult is the result of allocating devices. */
final case class DeviceAllocationResult(
  config : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration]] = None,
  results : Option[Seq[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult]] = None
) {

  /** Returns a new data with config set to new value */
  def withConfig(value: Seq[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration]) : DeviceAllocationResult = copy(config = Some(value))
  /** Appends new values to config */
  def addConfig(newValues: io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration*) : DeviceAllocationResult = copy(config = Some(config.fold(newValues)(_ ++ newValues)))
  /** if config has a value, transforms to the result of function*/
  def mapConfig(f: Seq[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration] => Seq[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration]) : DeviceAllocationResult = copy(config = config.map(f))

  /** Returns a new data with results set to new value */
  def withResults(value: Seq[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult]) : DeviceAllocationResult = copy(results = Some(value))
  /** Appends new values to results */
  def addResults(newValues: io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult*) : DeviceAllocationResult = copy(results = Some(results.fold(newValues)(_ ++ newValues)))
  /** if results has a value, transforms to the result of function*/
  def mapResults(f: Seq[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult] => Seq[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult]) : DeviceAllocationResult = copy(results = results.map(f))
}

object DeviceAllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceAllocationResult] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceAllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceAllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("config", o.config)
            .write("results", o.results)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceAllocationResult] = new Decoder[DeviceAllocationResult] {
      def apply[T : Reader](t: T): Either[String, DeviceAllocationResult] = for {
          obj <- ObjectReader(t)
          config <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration]]("config")
          results <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha3.DeviceRequestAllocationResult]]("results")
      } yield DeviceAllocationResult (
          config = config,
          results = results
        )
    }
}

