package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** DeviceAllocationConfiguration gets embedded in an AllocationResult. */
final case class DeviceAllocationConfiguration(
  source : String,
  opaque : Option[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration] = None,
  requests : Option[Seq[String]] = None
) {

  /** Returns a new data with source set to new value */
  def withSource(value: String) : DeviceAllocationConfiguration = copy(source = value)
  /** transforms source to result of function */
  def mapSource(f: String => String) : DeviceAllocationConfiguration = copy(source = f(source))

  /** Returns a new data with opaque set to new value */
  def withOpaque(value: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceAllocationConfiguration = copy(opaque = Some(value))
  /** if opaque has a value, transforms to the result of function*/
  def mapOpaque(f: io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration => io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration) : DeviceAllocationConfiguration = copy(opaque = opaque.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Seq[String]) : DeviceAllocationConfiguration = copy(requests = Some(value))
  /** Appends new values to requests */
  def addRequests(newValues: String*) : DeviceAllocationConfiguration = copy(requests = Some(requests.fold(newValues)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Seq[String] => Seq[String]) : DeviceAllocationConfiguration = copy(requests = requests.map(f))
}

object DeviceAllocationConfiguration {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration] = new Encoder[io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.DeviceAllocationConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("source", o.source)
            .write("opaque", o.opaque)
            .write("requests", o.requests)
            .build
        }
    }

    implicit val decoder: Decoder[DeviceAllocationConfiguration] = new Decoder[DeviceAllocationConfiguration] {
      def apply[T : Reader](t: T): Either[String, DeviceAllocationConfiguration] = for {
          obj <- ObjectReader(t)
          source <- obj.read[String]("source")
          opaque <- obj.readOpt[io.k8s.api.resource.v1alpha3.OpaqueDeviceConfiguration]("opaque")
          requests <- obj.readOpt[Seq[String]]("requests")
      } yield DeviceAllocationConfiguration (
          source = source,
          opaque = opaque,
          requests = requests
        )
    }
}

