package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set. */
final case class Device(
  name : String,
  basic : Option[io.k8s.api.resource.v1alpha3.BasicDevice] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : Device = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : Device = copy(name = f(name))

  /** Returns a new data with basic set to new value */
  def withBasic(value: io.k8s.api.resource.v1alpha3.BasicDevice) : Device = copy(basic = Some(value))
  /** if basic has a value, transforms to the result of function*/
  def mapBasic(f: io.k8s.api.resource.v1alpha3.BasicDevice => io.k8s.api.resource.v1alpha3.BasicDevice) : Device = copy(basic = basic.map(f))
}

object Device {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.Device] = new Encoder[io.k8s.api.resource.v1alpha3.Device] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.Device) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("basic", o.basic)
            .build
        }
    }

    implicit val decoder: Decoder[Device] = new Decoder[Device] {
      def apply[T : Reader](t: T): Either[String, Device] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          basic <- obj.readOpt[io.k8s.api.resource.v1alpha3.BasicDevice]("basic")
      } yield Device (
          name = name,
          basic = basic
        )
    }
}

