package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** CELDeviceSelector contains a CEL expression for selecting a device. */
final case class CELDeviceSelector(
  expression : String
) {

  /** Returns a new data with expression set to new value */
  def withExpression(value: String) : CELDeviceSelector = copy(expression = value)
  /** transforms expression to result of function */
  def mapExpression(f: String => String) : CELDeviceSelector = copy(expression = f(expression))
}

object CELDeviceSelector {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.CELDeviceSelector] = new Encoder[io.k8s.api.resource.v1alpha3.CELDeviceSelector] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.CELDeviceSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("expression", o.expression)
            .build
        }
    }

    implicit val decoder: Decoder[CELDeviceSelector] = new Decoder[CELDeviceSelector] {
      def apply[T : Reader](t: T): Either[String, CELDeviceSelector] = for {
          obj <- ObjectReader(t)
          expression <- obj.read[String]("expression")
      } yield CELDeviceSelector (
          expression = expression
        )
    }
}

