package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** BasicDevice defines one device instance. */
final case class BasicDevice(
  attributes : Option[Map[String, io.k8s.api.resource.v1alpha3.DeviceAttribute]] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with attributes set to new value */
  def withAttributes(value: Map[String, io.k8s.api.resource.v1alpha3.DeviceAttribute]) : BasicDevice = copy(attributes = Some(value))
  /** Adds new values to attributes */
  def addAttributes(newValues: (String, io.k8s.api.resource.v1alpha3.DeviceAttribute)*) : BasicDevice = copy(attributes = Some(attributes.fold(newValues.toMap)(_ ++ newValues)))
  /** if attributes has a value, transforms to the result of function*/
  def mapAttributes(f: Map[String, io.k8s.api.resource.v1alpha3.DeviceAttribute] => Map[String, io.k8s.api.resource.v1alpha3.DeviceAttribute]) : BasicDevice = copy(attributes = attributes.map(f))

  /** Returns a new data with capacity set to new value */
  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : BasicDevice = copy(capacity = Some(value))
  /** Adds new values to capacity */
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : BasicDevice = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))
  /** if capacity has a value, transforms to the result of function*/
  def mapCapacity(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : BasicDevice = copy(capacity = capacity.map(f))
}

object BasicDevice {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.BasicDevice] = new Encoder[io.k8s.api.resource.v1alpha3.BasicDevice] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.BasicDevice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("attributes", o.attributes)
            .write("capacity", o.capacity)
            .build
        }
    }

    implicit val decoder: Decoder[BasicDevice] = new Decoder[BasicDevice] {
      def apply[T : Reader](t: T): Either[String, BasicDevice] = for {
          obj <- ObjectReader(t)
          attributes <- obj.readOpt[Map[String, io.k8s.api.resource.v1alpha3.DeviceAttribute]]("attributes")
          capacity <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("capacity")
      } yield BasicDevice (
          attributes = attributes,
          capacity = capacity
        )
    }
}

