package io.k8s.api.resource.v1alpha3

import dev.hnaderi.k8s.utils._

/** AllocationResult contains attributes of an allocated resource. */
final case class AllocationResult(
  controller : Option[String] = None,
  devices : Option[io.k8s.api.resource.v1alpha3.DeviceAllocationResult] = None,
  nodeSelector : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with controller set to new value */
  def withController(value: String) : AllocationResult = copy(controller = Some(value))
  /** if controller has a value, transforms to the result of function*/
  def mapController(f: String => String) : AllocationResult = copy(controller = controller.map(f))

  /** Returns a new data with devices set to new value */
  def withDevices(value: io.k8s.api.resource.v1alpha3.DeviceAllocationResult) : AllocationResult = copy(devices = Some(value))
  /** if devices has a value, transforms to the result of function*/
  def mapDevices(f: io.k8s.api.resource.v1alpha3.DeviceAllocationResult => io.k8s.api.resource.v1alpha3.DeviceAllocationResult) : AllocationResult = copy(devices = devices.map(f))

  /** Returns a new data with nodeSelector set to new value */
  def withNodeSelector(value: io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(nodeSelector = Some(value))
  /** if nodeSelector has a value, transforms to the result of function*/
  def mapNodeSelector(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : AllocationResult = copy(nodeSelector = nodeSelector.map(f))
}

object AllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha3.AllocationResult] = new Encoder[io.k8s.api.resource.v1alpha3.AllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha3.AllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("controller", o.controller)
            .write("devices", o.devices)
            .write("nodeSelector", o.nodeSelector)
            .build
        }
    }

    implicit val decoder: Decoder[AllocationResult] = new Decoder[AllocationResult] {
      def apply[T : Reader](t: T): Either[String, AllocationResult] = for {
          obj <- ObjectReader(t)
          controller <- obj.readOpt[String]("controller")
          devices <- obj.readOpt[io.k8s.api.resource.v1alpha3.DeviceAllocationResult]("devices")
          nodeSelector <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("nodeSelector")
      } yield AllocationResult (
          controller = controller,
          devices = devices,
          nodeSelector = nodeSelector
        )
    }
}

