package io.k8s.api.networking.v1beta1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ServiceCIDR defines a range of IP addresses using CIDR format (e.g. 192.168.0.0/24 or 2001:db2::/64). This range is used to allocate ClusterIPs to Service objects. */
final case class ServiceCIDR(
  status : Option[io.k8s.api.networking.v1beta1.ServiceCIDRStatus] = None,
  spec : Option[io.k8s.api.networking.v1beta1.ServiceCIDRSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "ServiceCIDR", "v1beta1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.networking.v1beta1.ServiceCIDRStatus) : ServiceCIDR = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.networking.v1beta1.ServiceCIDRStatus => io.k8s.api.networking.v1beta1.ServiceCIDRStatus) : ServiceCIDR = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1beta1.ServiceCIDRSpec) : ServiceCIDR = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1beta1.ServiceCIDRSpec => io.k8s.api.networking.v1beta1.ServiceCIDRSpec) : ServiceCIDR = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ServiceCIDR = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ServiceCIDR = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ServiceCIDR.encoder.apply(this)
}

object ServiceCIDR {

    implicit val encoder : Encoder[io.k8s.api.networking.v1beta1.ServiceCIDR] = new Encoder[io.k8s.api.networking.v1beta1.ServiceCIDR] {
        def apply[T : Builder](o: io.k8s.api.networking.v1beta1.ServiceCIDR) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ServiceCIDR] = new Decoder[ServiceCIDR] {
      def apply[T : Reader](t: T): Either[String, ServiceCIDR] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.networking.v1beta1.ServiceCIDRStatus]("status")
          spec <- obj.readOpt[io.k8s.api.networking.v1beta1.ServiceCIDRSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ServiceCIDR (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

