package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Projection that may be projected along with other supported volume types. Exactly one of these fields must be set. */
final case class VolumeProjection(
  secret : Option[io.k8s.api.core.v1.SecretProjection] = None,
  configMap : Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  clusterTrustBundle : Option[io.k8s.api.core.v1.ClusterTrustBundleProjection] = None,
  serviceAccountToken : Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None,
  downwardAPI : Option[io.k8s.api.core.v1.DownwardAPIProjection] = None
) {

  /** Returns a new data with secret set to new value */
  def withSecret(value: io.k8s.api.core.v1.SecretProjection) : VolumeProjection = copy(secret = Some(value))
  /** if secret has a value, transforms to the result of function*/
  def mapSecret(f: io.k8s.api.core.v1.SecretProjection => io.k8s.api.core.v1.SecretProjection) : VolumeProjection = copy(secret = secret.map(f))

  /** Returns a new data with configMap set to new value */
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapProjection) : VolumeProjection = copy(configMap = Some(value))
  /** if configMap has a value, transforms to the result of function*/
  def mapConfigMap(f: io.k8s.api.core.v1.ConfigMapProjection => io.k8s.api.core.v1.ConfigMapProjection) : VolumeProjection = copy(configMap = configMap.map(f))

  /** Returns a new data with clusterTrustBundle set to new value */
  def withClusterTrustBundle(value: io.k8s.api.core.v1.ClusterTrustBundleProjection) : VolumeProjection = copy(clusterTrustBundle = Some(value))
  /** if clusterTrustBundle has a value, transforms to the result of function*/
  def mapClusterTrustBundle(f: io.k8s.api.core.v1.ClusterTrustBundleProjection => io.k8s.api.core.v1.ClusterTrustBundleProjection) : VolumeProjection = copy(clusterTrustBundle = clusterTrustBundle.map(f))

  /** Returns a new data with serviceAccountToken set to new value */
  def withServiceAccountToken(value: io.k8s.api.core.v1.ServiceAccountTokenProjection) : VolumeProjection = copy(serviceAccountToken = Some(value))
  /** if serviceAccountToken has a value, transforms to the result of function*/
  def mapServiceAccountToken(f: io.k8s.api.core.v1.ServiceAccountTokenProjection => io.k8s.api.core.v1.ServiceAccountTokenProjection) : VolumeProjection = copy(serviceAccountToken = serviceAccountToken.map(f))

  /** Returns a new data with downwardAPI set to new value */
  def withDownwardAPI(value: io.k8s.api.core.v1.DownwardAPIProjection) : VolumeProjection = copy(downwardAPI = Some(value))
  /** if downwardAPI has a value, transforms to the result of function*/
  def mapDownwardAPI(f: io.k8s.api.core.v1.DownwardAPIProjection => io.k8s.api.core.v1.DownwardAPIProjection) : VolumeProjection = copy(downwardAPI = downwardAPI.map(f))
}

object VolumeProjection {

    implicit val encoder : Encoder[io.k8s.api.core.v1.VolumeProjection] = new Encoder[io.k8s.api.core.v1.VolumeProjection] {
        def apply[T : Builder](o: io.k8s.api.core.v1.VolumeProjection) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("secret", o.secret)
            .write("configMap", o.configMap)
            .write("clusterTrustBundle", o.clusterTrustBundle)
            .write("serviceAccountToken", o.serviceAccountToken)
            .write("downwardAPI", o.downwardAPI)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeProjection] = new Decoder[VolumeProjection] {
      def apply[T : Reader](t: T): Either[String, VolumeProjection] = for {
          obj <- ObjectReader(t)
          secret <- obj.readOpt[io.k8s.api.core.v1.SecretProjection]("secret")
          configMap <- obj.readOpt[io.k8s.api.core.v1.ConfigMapProjection]("configMap")
          clusterTrustBundle <- obj.readOpt[io.k8s.api.core.v1.ClusterTrustBundleProjection]("clusterTrustBundle")
          serviceAccountToken <- obj.readOpt[io.k8s.api.core.v1.ServiceAccountTokenProjection]("serviceAccountToken")
          downwardAPI <- obj.readOpt[io.k8s.api.core.v1.DownwardAPIProjection]("downwardAPI")
      } yield VolumeProjection (
          secret = secret,
          configMap = configMap,
          clusterTrustBundle = clusterTrustBundle,
          serviceAccountToken = serviceAccountToken,
          downwardAPI = downwardAPI
        )
    }
}

