package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._


final case class ResourceStatus(
  name : String,
  resources : Option[Seq[io.k8s.api.core.v1.ResourceHealth]] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceStatus = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceStatus = copy(name = f(name))

  /** Returns a new data with resources set to new value */
  def withResources(value: Seq[io.k8s.api.core.v1.ResourceHealth]) : ResourceStatus = copy(resources = Some(value))
  /** Appends new values to resources */
  def addResources(newValues: io.k8s.api.core.v1.ResourceHealth*) : ResourceStatus = copy(resources = Some(resources.fold(newValues)(_ ++ newValues)))
  /** if resources has a value, transforms to the result of function*/
  def mapResources(f: Seq[io.k8s.api.core.v1.ResourceHealth] => Seq[io.k8s.api.core.v1.ResourceHealth]) : ResourceStatus = copy(resources = resources.map(f))
}

object ResourceStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ResourceStatus] = new Encoder[io.k8s.api.core.v1.ResourceStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ResourceStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("resources", o.resources)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceStatus] = new Decoder[ResourceStatus] {
      def apply[T : Reader](t: T): Either[String, ResourceStatus] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          resources <- obj.readOpt[Seq[io.k8s.api.core.v1.ResourceHealth]]("resources")
      } yield ResourceStatus (
          name = name,
          resources = resources
        )
    }
}

