package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ResourceClaim references one entry in PodSpec.ResourceClaims. */
final case class ResourceClaim(
  name : String,
  request : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClaim = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceClaim = copy(name = f(name))

  /** Returns a new data with request set to new value */
  def withRequest(value: String) : ResourceClaim = copy(request = Some(value))
  /** if request has a value, transforms to the result of function*/
  def mapRequest(f: String => String) : ResourceClaim = copy(request = request.map(f))
}

object ResourceClaim {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ResourceClaim] = new Encoder[io.k8s.api.core.v1.ResourceClaim] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ResourceClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("request", o.request)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaim] = new Decoder[ResourceClaim] {
      def apply[T : Reader](t: T): Either[String, ResourceClaim] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          request <- obj.readOpt[String]("request")
      } yield ResourceClaim (
          name = name,
          request = request
        )
    }
}

