package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodIP represents a single IP address allocated to the pod. */
final case class PodIP(
  ip : String
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : PodIP = copy(ip = value)
  /** transforms ip to result of function */
  def mapIp(f: String => String) : PodIP = copy(ip = f(ip))
}

object PodIP {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodIP] = new Encoder[io.k8s.api.core.v1.PodIP] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodIP) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ip", o.ip)
            .build
        }
    }

    implicit val decoder: Decoder[PodIP] = new Decoder[PodIP] {
      def apply[T : Reader](t: T): Either[String, PodIP] = for {
          obj <- ObjectReader(t)
          ip <- obj.read[String]("ip")
      } yield PodIP (
          ip = ip
        )
    }
}

