package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers. */
final case class NodeFeatures(
  supplementalGroupsPolicy : Option[Boolean] = None
) {

  /** Returns a new data with supplementalGroupsPolicy set to new value */
  def withSupplementalGroupsPolicy(value: Boolean) : NodeFeatures = copy(supplementalGroupsPolicy = Some(value))
  /** if supplementalGroupsPolicy has a value, transforms to the result of function*/
  def mapSupplementalGroupsPolicy(f: Boolean => Boolean) : NodeFeatures = copy(supplementalGroupsPolicy = supplementalGroupsPolicy.map(f))
}

object NodeFeatures {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeFeatures] = new Encoder[io.k8s.api.core.v1.NodeFeatures] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeFeatures) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("supplementalGroupsPolicy", o.supplementalGroupsPolicy)
            .build
        }
    }

    implicit val decoder: Decoder[NodeFeatures] = new Decoder[NodeFeatures] {
      def apply[T : Reader](t: T): Either[String, NodeFeatures] = for {
          obj <- ObjectReader(t)
          supplementalGroupsPolicy <- obj.readOpt[Boolean]("supplementalGroupsPolicy")
      } yield NodeFeatures (
          supplementalGroupsPolicy = supplementalGroupsPolicy
        )
    }
}

