package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Namespace provides a scope for Names. Use of multiple namespaces is optional. */
final case class Namespace(
  status : Option[io.k8s.api.core.v1.NamespaceStatus] = None,
  spec : Option[io.k8s.api.core.v1.NamespaceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Namespace", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.NamespaceStatus) : Namespace = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.NamespaceStatus => io.k8s.api.core.v1.NamespaceStatus) : Namespace = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.NamespaceSpec) : Namespace = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.NamespaceSpec => io.k8s.api.core.v1.NamespaceSpec) : Namespace = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Namespace = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Namespace = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Namespace.encoder.apply(this)
}

object Namespace {

    implicit val encoder : Encoder[io.k8s.api.core.v1.Namespace] = new Encoder[io.k8s.api.core.v1.Namespace] {
        def apply[T : Builder](o: io.k8s.api.core.v1.Namespace) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Namespace] = new Decoder[Namespace] {
      def apply[T : Reader](t: T): Either[String, Namespace] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.NamespaceStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.NamespaceSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Namespace (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

