package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ImageVolumeSource represents a image volume resource. */
final case class ImageVolumeSource(
  pullPolicy : Option[String] = None,
  reference : Option[String] = None
) {

  /** Returns a new data with pullPolicy set to new value */
  def withPullPolicy(value: String) : ImageVolumeSource = copy(pullPolicy = Some(value))
  /** if pullPolicy has a value, transforms to the result of function*/
  def mapPullPolicy(f: String => String) : ImageVolumeSource = copy(pullPolicy = pullPolicy.map(f))

  /** Returns a new data with reference set to new value */
  def withReference(value: String) : ImageVolumeSource = copy(reference = Some(value))
  /** if reference has a value, transforms to the result of function*/
  def mapReference(f: String => String) : ImageVolumeSource = copy(reference = reference.map(f))
}

object ImageVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ImageVolumeSource] = new Encoder[io.k8s.api.core.v1.ImageVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ImageVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("pullPolicy", o.pullPolicy)
            .write("reference", o.reference)
            .build
        }
    }

    implicit val decoder: Decoder[ImageVolumeSource] = new Decoder[ImageVolumeSource] {
      def apply[T : Reader](t: T): Either[String, ImageVolumeSource] = for {
          obj <- ObjectReader(t)
          pullPolicy <- obj.readOpt[String]("pullPolicy")
          reference <- obj.readOpt[String]("reference")
      } yield ImageVolumeSource (
          pullPolicy = pullPolicy,
          reference = reference
        )
    }
}

