package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ContainerUser represents user identity information */
final case class ContainerUser(
  linux : Option[io.k8s.api.core.v1.LinuxContainerUser] = None
) {

  /** Returns a new data with linux set to new value */
  def withLinux(value: io.k8s.api.core.v1.LinuxContainerUser) : ContainerUser = copy(linux = Some(value))
  /** if linux has a value, transforms to the result of function*/
  def mapLinux(f: io.k8s.api.core.v1.LinuxContainerUser => io.k8s.api.core.v1.LinuxContainerUser) : ContainerUser = copy(linux = linux.map(f))
}

object ContainerUser {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ContainerUser] = new Encoder[io.k8s.api.core.v1.ContainerUser] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ContainerUser) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("linux", o.linux)
            .build
        }
    }

    implicit val decoder: Decoder[ContainerUser] = new Decoder[ContainerUser] {
      def apply[T : Reader](t: T): Either[String, ContainerUser] = for {
          obj <- ObjectReader(t)
          linux <- obj.readOpt[io.k8s.api.core.v1.LinuxContainerUser]("linux")
      } yield ContainerUser (
          linux = linux
        )
    }
}

