package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem. */
final case class ClusterTrustBundleProjection(
  path : String,
  name : Option[String] = None,
  labelSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  optional : Option[Boolean] = None,
  signerName : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : ClusterTrustBundleProjection = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : ClusterTrustBundleProjection = copy(path = f(path))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ClusterTrustBundleProjection = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ClusterTrustBundleProjection = copy(name = name.map(f))

  /** Returns a new data with labelSelector set to new value */
  def withLabelSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ClusterTrustBundleProjection = copy(labelSelector = Some(value))
  /** if labelSelector has a value, transforms to the result of function*/
  def mapLabelSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ClusterTrustBundleProjection = copy(labelSelector = labelSelector.map(f))

  /** Returns a new data with optional set to new value */
  def withOptional(value: Boolean) : ClusterTrustBundleProjection = copy(optional = Some(value))
  /** if optional has a value, transforms to the result of function*/
  def mapOptional(f: Boolean => Boolean) : ClusterTrustBundleProjection = copy(optional = optional.map(f))

  /** Returns a new data with signerName set to new value */
  def withSignerName(value: String) : ClusterTrustBundleProjection = copy(signerName = Some(value))
  /** if signerName has a value, transforms to the result of function*/
  def mapSignerName(f: String => String) : ClusterTrustBundleProjection = copy(signerName = signerName.map(f))
}

object ClusterTrustBundleProjection {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ClusterTrustBundleProjection] = new Encoder[io.k8s.api.core.v1.ClusterTrustBundleProjection] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ClusterTrustBundleProjection) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("path", o.path)
            .write("name", o.name)
            .write("labelSelector", o.labelSelector)
            .write("optional", o.optional)
            .write("signerName", o.signerName)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterTrustBundleProjection] = new Decoder[ClusterTrustBundleProjection] {
      def apply[T : Reader](t: T): Either[String, ClusterTrustBundleProjection] = for {
          obj <- ObjectReader(t)
          path <- obj.read[String]("path")
          name <- obj.readOpt[String]("name")
          labelSelector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("labelSelector")
          optional <- obj.readOpt[Boolean]("optional")
          signerName <- obj.readOpt[String]("signerName")
      } yield ClusterTrustBundleProjection (
          path = path,
          name = name,
          labelSelector = labelSelector,
          optional = optional,
          signerName = signerName
        )
    }
}

