package io.k8s.api.coordination.v1alpha1

import dev.hnaderi.k8s.utils._

/** LeaseCandidateSpec is a specification of a Lease. */
final case class LeaseCandidateSpec(
  preferredStrategies : Seq[String],
  leaseName : String,
  emulationVersion : Option[String] = None,
  binaryVersion : Option[String] = None,
  renewTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  pingTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
) {

  /** Returns a new data with preferredStrategies set to new value */
  def withPreferredStrategies(value: Seq[String]) : LeaseCandidateSpec = copy(preferredStrategies = value)
  /** Appends new values to preferredStrategies */
  def addPreferredStrategies(newValues: String*) : LeaseCandidateSpec = copy(preferredStrategies = preferredStrategies ++ newValues)
  /** transforms preferredStrategies to result of function */
  def mapPreferredStrategies(f: Seq[String] => Seq[String]) : LeaseCandidateSpec = copy(preferredStrategies = f(preferredStrategies))

  /** Returns a new data with leaseName set to new value */
  def withLeaseName(value: String) : LeaseCandidateSpec = copy(leaseName = value)
  /** transforms leaseName to result of function */
  def mapLeaseName(f: String => String) : LeaseCandidateSpec = copy(leaseName = f(leaseName))

  /** Returns a new data with emulationVersion set to new value */
  def withEmulationVersion(value: String) : LeaseCandidateSpec = copy(emulationVersion = Some(value))
  /** if emulationVersion has a value, transforms to the result of function*/
  def mapEmulationVersion(f: String => String) : LeaseCandidateSpec = copy(emulationVersion = emulationVersion.map(f))

  /** Returns a new data with binaryVersion set to new value */
  def withBinaryVersion(value: String) : LeaseCandidateSpec = copy(binaryVersion = Some(value))
  /** if binaryVersion has a value, transforms to the result of function*/
  def mapBinaryVersion(f: String => String) : LeaseCandidateSpec = copy(binaryVersion = binaryVersion.map(f))

  /** Returns a new data with renewTime set to new value */
  def withRenewTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseCandidateSpec = copy(renewTime = Some(value))
  /** if renewTime has a value, transforms to the result of function*/
  def mapRenewTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseCandidateSpec = copy(renewTime = renewTime.map(f))

  /** Returns a new data with pingTime set to new value */
  def withPingTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseCandidateSpec = copy(pingTime = Some(value))
  /** if pingTime has a value, transforms to the result of function*/
  def mapPingTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseCandidateSpec = copy(pingTime = pingTime.map(f))
}

object LeaseCandidateSpec {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec] = new Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("preferredStrategies", o.preferredStrategies)
            .write("leaseName", o.leaseName)
            .write("emulationVersion", o.emulationVersion)
            .write("binaryVersion", o.binaryVersion)
            .write("renewTime", o.renewTime)
            .write("pingTime", o.pingTime)
            .build
        }
    }

    implicit val decoder: Decoder[LeaseCandidateSpec] = new Decoder[LeaseCandidateSpec] {
      def apply[T : Reader](t: T): Either[String, LeaseCandidateSpec] = for {
          obj <- ObjectReader(t)
          preferredStrategies <- obj.read[Seq[String]]("preferredStrategies")
          leaseName <- obj.read[String]("leaseName")
          emulationVersion <- obj.readOpt[String]("emulationVersion")
          binaryVersion <- obj.readOpt[String]("binaryVersion")
          renewTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("renewTime")
          pingTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("pingTime")
      } yield LeaseCandidateSpec (
          preferredStrategies = preferredStrategies,
          leaseName = leaseName,
          emulationVersion = emulationVersion,
          binaryVersion = binaryVersion,
          renewTime = renewTime,
          pingTime = pingTime
        )
    }
}

