package io.k8s.api.coordination.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** LeaseCandidateList is a list of Lease objects. */
final case class LeaseCandidateList(
  items : Seq[io.k8s.api.coordination.v1alpha1.LeaseCandidate],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "LeaseCandidateList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.coordination.v1alpha1.LeaseCandidate]) : LeaseCandidateList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.coordination.v1alpha1.LeaseCandidate*) : LeaseCandidateList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.coordination.v1alpha1.LeaseCandidate] => Seq[io.k8s.api.coordination.v1alpha1.LeaseCandidate]) : LeaseCandidateList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseCandidateList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseCandidateList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = LeaseCandidateList.encoder.apply(this)
}

object LeaseCandidateList {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidateList] = new Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidateList] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1alpha1.LeaseCandidateList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[LeaseCandidateList] = new Decoder[LeaseCandidateList] {
      def apply[T : Reader](t: T): Either[String, LeaseCandidateList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.coordination.v1alpha1.LeaseCandidate]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield LeaseCandidateList (
          items = items,
          metadata = metadata
        )
    }
}

