package io.k8s.api.coordination.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** LeaseCandidate defines a candidate for a Lease object. Candidates are created such that coordinated leader election will pick the best leader from the list of candidates. */
final case class LeaseCandidate(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "LeaseCandidate", "v1alpha1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LeaseCandidate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LeaseCandidate = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec) : LeaseCandidate = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec => io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec) : LeaseCandidate = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = LeaseCandidate.encoder.apply(this)
}

object LeaseCandidate {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidate] = new Encoder[io.k8s.api.coordination.v1alpha1.LeaseCandidate] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1alpha1.LeaseCandidate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[LeaseCandidate] = new Decoder[LeaseCandidate] {
      def apply[T : Reader](t: T): Either[String, LeaseCandidate] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.coordination.v1alpha1.LeaseCandidateSpec]("spec")
      } yield LeaseCandidate (
          metadata = metadata,
          spec = spec
        )
    }
}

