package io.k8s.api.coordination.v1

import dev.hnaderi.k8s.utils._

/** LeaseSpec is a specification of a Lease. */
final case class LeaseSpec(
  leaseTransitions : Option[Int] = None,
  holderIdentity : Option[String] = None,
  leaseDurationSeconds : Option[Int] = None,
  renewTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  preferredHolder : Option[String] = None,
  acquireTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  strategy : Option[String] = None
) {

  /** Returns a new data with leaseTransitions set to new value */
  def withLeaseTransitions(value: Int) : LeaseSpec = copy(leaseTransitions = Some(value))
  /** if leaseTransitions has a value, transforms to the result of function*/
  def mapLeaseTransitions(f: Int => Int) : LeaseSpec = copy(leaseTransitions = leaseTransitions.map(f))

  /** Returns a new data with holderIdentity set to new value */
  def withHolderIdentity(value: String) : LeaseSpec = copy(holderIdentity = Some(value))
  /** if holderIdentity has a value, transforms to the result of function*/
  def mapHolderIdentity(f: String => String) : LeaseSpec = copy(holderIdentity = holderIdentity.map(f))

  /** Returns a new data with leaseDurationSeconds set to new value */
  def withLeaseDurationSeconds(value: Int) : LeaseSpec = copy(leaseDurationSeconds = Some(value))
  /** if leaseDurationSeconds has a value, transforms to the result of function*/
  def mapLeaseDurationSeconds(f: Int => Int) : LeaseSpec = copy(leaseDurationSeconds = leaseDurationSeconds.map(f))

  /** Returns a new data with renewTime set to new value */
  def withRenewTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(renewTime = Some(value))
  /** if renewTime has a value, transforms to the result of function*/
  def mapRenewTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(renewTime = renewTime.map(f))

  /** Returns a new data with preferredHolder set to new value */
  def withPreferredHolder(value: String) : LeaseSpec = copy(preferredHolder = Some(value))
  /** if preferredHolder has a value, transforms to the result of function*/
  def mapPreferredHolder(f: String => String) : LeaseSpec = copy(preferredHolder = preferredHolder.map(f))

  /** Returns a new data with acquireTime set to new value */
  def withAcquireTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(acquireTime = Some(value))
  /** if acquireTime has a value, transforms to the result of function*/
  def mapAcquireTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(acquireTime = acquireTime.map(f))

  /** Returns a new data with strategy set to new value */
  def withStrategy(value: String) : LeaseSpec = copy(strategy = Some(value))
  /** if strategy has a value, transforms to the result of function*/
  def mapStrategy(f: String => String) : LeaseSpec = copy(strategy = strategy.map(f))
}

object LeaseSpec {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1.LeaseSpec] = new Encoder[io.k8s.api.coordination.v1.LeaseSpec] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1.LeaseSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("leaseTransitions", o.leaseTransitions)
            .write("holderIdentity", o.holderIdentity)
            .write("leaseDurationSeconds", o.leaseDurationSeconds)
            .write("renewTime", o.renewTime)
            .write("preferredHolder", o.preferredHolder)
            .write("acquireTime", o.acquireTime)
            .write("strategy", o.strategy)
            .build
        }
    }

    implicit val decoder: Decoder[LeaseSpec] = new Decoder[LeaseSpec] {
      def apply[T : Reader](t: T): Either[String, LeaseSpec] = for {
          obj <- ObjectReader(t)
          leaseTransitions <- obj.readOpt[Int]("leaseTransitions")
          holderIdentity <- obj.readOpt[String]("holderIdentity")
          leaseDurationSeconds <- obj.readOpt[Int]("leaseDurationSeconds")
          renewTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("renewTime")
          preferredHolder <- obj.readOpt[String]("preferredHolder")
          acquireTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("acquireTime")
          strategy <- obj.readOpt[String]("strategy")
      } yield LeaseSpec (
          leaseTransitions = leaseTransitions,
          holderIdentity = holderIdentity,
          leaseDurationSeconds = leaseDurationSeconds,
          renewTime = renewTime,
          preferredHolder = preferredHolder,
          acquireTime = acquireTime,
          strategy = strategy
        )
    }
}

