package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule. */
final case class PodFailurePolicyRule(
  action : String,
  onExitCodes : Option[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] = None,
  onPodConditions : Option[Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]] = None
) {

  /** Returns a new data with action set to new value */
  def withAction(value: String) : PodFailurePolicyRule = copy(action = value)
  /** transforms action to result of function */
  def mapAction(f: String => String) : PodFailurePolicyRule = copy(action = f(action))

  /** Returns a new data with onExitCodes set to new value */
  def withOnExitCodes(value: io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement) : PodFailurePolicyRule = copy(onExitCodes = Some(value))
  /** if onExitCodes has a value, transforms to the result of function*/
  def mapOnExitCodes(f: io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement => io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement) : PodFailurePolicyRule = copy(onExitCodes = onExitCodes.map(f))

  /** Returns a new data with onPodConditions set to new value */
  def withOnPodConditions(value: Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]) : PodFailurePolicyRule = copy(onPodConditions = Some(value))
  /** Appends new values to onPodConditions */
  def addOnPodConditions(newValues: io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern*) : PodFailurePolicyRule = copy(onPodConditions = Some(onPodConditions.fold(newValues)(_ ++ newValues)))
  /** if onPodConditions has a value, transforms to the result of function*/
  def mapOnPodConditions(f: Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern] => Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]) : PodFailurePolicyRule = copy(onPodConditions = onPodConditions.map(f))
}

object PodFailurePolicyRule {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicyRule] = new Encoder[io.k8s.api.batch.v1.PodFailurePolicyRule] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.PodFailurePolicyRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("action", o.action)
            .write("onExitCodes", o.onExitCodes)
            .write("onPodConditions", o.onPodConditions)
            .build
        }
    }

    implicit val decoder: Decoder[PodFailurePolicyRule] = new Decoder[PodFailurePolicyRule] {
      def apply[T : Reader](t: T): Either[String, PodFailurePolicyRule] = for {
          obj <- ObjectReader(t)
          action <- obj.read[String]("action")
          onExitCodes <- obj.readOpt[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement]("onExitCodes")
          onPodConditions <- obj.readOpt[Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]]("onPodConditions")
      } yield PodFailurePolicyRule (
          action = action,
          onExitCodes = onExitCodes,
          onPodConditions = onPodConditions
        )
    }
}

