package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding. */
final case class ParamRef(
  name : Option[String] = None,
  namespace : Option[String] = None,
  parameterNotFoundAction : Option[String] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ParamRef = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ParamRef = copy(name = name.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ParamRef = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ParamRef = copy(namespace = namespace.map(f))

  /** Returns a new data with parameterNotFoundAction set to new value */
  def withParameterNotFoundAction(value: String) : ParamRef = copy(parameterNotFoundAction = Some(value))
  /** if parameterNotFoundAction has a value, transforms to the result of function*/
  def mapParameterNotFoundAction(f: String => String) : ParamRef = copy(parameterNotFoundAction = parameterNotFoundAction.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ParamRef = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ParamRef = copy(selector = selector.map(f))
}

object ParamRef {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ParamRef] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ParamRef] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ParamRef) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("namespace", o.namespace)
            .write("parameterNotFoundAction", o.parameterNotFoundAction)
            .write("selector", o.selector)
            .build
        }
    }

    implicit val decoder: Decoder[ParamRef] = new Decoder[ParamRef] {
      def apply[T : Reader](t: T): Either[String, ParamRef] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          namespace <- obj.readOpt[String]("namespace")
          parameterNotFoundAction <- obj.readOpt[String]("parameterNotFoundAction")
          selector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
      } yield ParamRef (
          name = name,
          namespace = namespace,
          parameterNotFoundAction = parameterNotFoundAction,
          selector = selector
        )
    }
}

