package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceHandle holds opaque resource data for processing by a specific kubelet plugin. */
final case class ResourceHandle(
  data : Option[String] = None,
  driverName : Option[String] = None
) {

  /** Returns a new data with data set to new value */
  def withData(value: String) : ResourceHandle = copy(data = Some(value))
  /** if data has a value, transforms to the result of function*/
  def mapData(f: String => String) : ResourceHandle = copy(data = data.map(f))

  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : ResourceHandle = copy(driverName = Some(value))
  /** if driverName has a value, transforms to the result of function*/
  def mapDriverName(f: String => String) : ResourceHandle = copy(driverName = driverName.map(f))
}

object ResourceHandle {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceHandle] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceHandle] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceHandle) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("data", o.data)
            .write("driverName", o.driverName)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceHandle] = new Decoder[ResourceHandle] {
      def apply[T : Reader](t: T): Either[String, ResourceHandle] = for {
          obj <- ObjectReader(t)
          data <- obj.readOpt[String]("data")
          driverName <- obj.readOpt[String]("driverName")
      } yield ResourceHandle (
          data = data,
          driverName = driverName
        )
    }
}

