package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** ParentReference describes a reference to a parent object. */
final case class ParentReference(
  group : Option[String] = None,
  name : Option[String] = None,
  namespace : Option[String] = None,
  resource : Option[String] = None
) {

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : ParentReference = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : ParentReference = copy(group = group.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ParentReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ParentReference = copy(name = name.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ParentReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ParentReference = copy(namespace = namespace.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: String) : ParentReference = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: String => String) : ParentReference = copy(resource = resource.map(f))
}

object ParentReference {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ParentReference] = new Encoder[io.k8s.api.networking.v1alpha1.ParentReference] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ParentReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("group", o.group)
            .write("name", o.name)
            .write("namespace", o.namespace)
            .write("resource", o.resource)
            .build
        }
    }

    implicit val decoder: Decoder[ParentReference] = new Decoder[ParentReference] {
      def apply[T : Reader](t: T): Either[String, ParentReference] = for {
          obj <- ObjectReader(t)
          group <- obj.readOpt[String]("group")
          name <- obj.readOpt[String]("name")
          namespace <- obj.readOpt[String]("namespace")
          resource <- obj.readOpt[String]("resource")
      } yield ParentReference (
          group = group,
          name = name,
          namespace = namespace,
          resource = resource
        )
    }
}

