package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** VolumeResourceRequirements describes the storage resource requirements for a volume. */
final case class VolumeResourceRequirements(
  limits : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with limits set to new value */
  def withLimits(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : VolumeResourceRequirements = copy(limits = Some(value))
  /** Adds new values to limits */
  def addLimits(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : VolumeResourceRequirements = copy(limits = Some(limits.fold(newValues.toMap)(_ ++ newValues)))
  /** if limits has a value, transforms to the result of function*/
  def mapLimits(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : VolumeResourceRequirements = copy(limits = limits.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : VolumeResourceRequirements = copy(requests = Some(value))
  /** Adds new values to requests */
  def addRequests(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : VolumeResourceRequirements = copy(requests = Some(requests.fold(newValues.toMap)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : VolumeResourceRequirements = copy(requests = requests.map(f))
}

object VolumeResourceRequirements {

    implicit val encoder : Encoder[io.k8s.api.core.v1.VolumeResourceRequirements] = new Encoder[io.k8s.api.core.v1.VolumeResourceRequirements] {
        def apply[T : Builder](o: io.k8s.api.core.v1.VolumeResourceRequirements) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("limits", o.limits)
            .write("requests", o.requests)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeResourceRequirements] = new Decoder[VolumeResourceRequirements] {
      def apply[T : Reader](t: T): Either[String, VolumeResourceRequirements] = for {
          obj <- ObjectReader(t)
          limits <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("limits")
          requests <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("requests")
      } yield VolumeResourceRequirements (
          limits = limits,
          requests = requests
        )
    }
}

