package io.k8s.api.certificates.v1alpha1

import dev.hnaderi.k8s.utils._

/** ClusterTrustBundleSpec contains the signer and trust anchors. */
final case class ClusterTrustBundleSpec(
  trustBundle : String,
  signerName : Option[String] = None
) {

  /** Returns a new data with trustBundle set to new value */
  def withTrustBundle(value: String) : ClusterTrustBundleSpec = copy(trustBundle = value)
  /** transforms trustBundle to result of function */
  def mapTrustBundle(f: String => String) : ClusterTrustBundleSpec = copy(trustBundle = f(trustBundle))

  /** Returns a new data with signerName set to new value */
  def withSignerName(value: String) : ClusterTrustBundleSpec = copy(signerName = Some(value))
  /** if signerName has a value, transforms to the result of function*/
  def mapSignerName(f: String => String) : ClusterTrustBundleSpec = copy(signerName = signerName.map(f))
}

object ClusterTrustBundleSpec {

    implicit val encoder : Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec] = new Encoder[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec] {
        def apply[T : Builder](o: io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("trustBundle", o.trustBundle)
            .write("signerName", o.signerName)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterTrustBundleSpec] = new Decoder[ClusterTrustBundleSpec] {
      def apply[T : Reader](t: T): Either[String, ClusterTrustBundleSpec] = for {
          obj <- ObjectReader(t)
          trustBundle <- obj.read[String]("trustBundle")
          signerName <- obj.readOpt[String]("signerName")
      } yield ClusterTrustBundleSpec (
          trustBundle = trustBundle,
          signerName = signerName
        )
    }
}

