package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it. */
final case class ValidatingAdmissionPolicy(
  status : Option[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus] = None,
  spec : Option[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingAdmissionPolicy", "v1alpha1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus) : ValidatingAdmissionPolicy = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus => io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus) : ValidatingAdmissionPolicy = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : ValidatingAdmissionPolicy = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec => io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : ValidatingAdmissionPolicy = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicy = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicy = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ValidatingAdmissionPolicy.encoder.apply(this)
}

object ValidatingAdmissionPolicy {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicy] = new Decoder[ValidatingAdmissionPolicy] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicy] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus]("status")
          spec <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ValidatingAdmissionPolicy (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

