package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodSchedulingContextList is a collection of Pod scheduling objects. */
final case class PodSchedulingContextList(
  items : Seq[io.k8s.api.resource.v1alpha2.PodSchedulingContext],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "PodSchedulingContextList", "v1alpha2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha2.PodSchedulingContext]) : PodSchedulingContextList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha2.PodSchedulingContext*) : PodSchedulingContextList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha2.PodSchedulingContext] => Seq[io.k8s.api.resource.v1alpha2.PodSchedulingContext]) : PodSchedulingContextList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodSchedulingContextList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodSchedulingContextList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodSchedulingContextList.encoder.apply(this)
}

object PodSchedulingContextList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContextList] = new Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContextList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.PodSchedulingContextList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingContextList] = new Decoder[PodSchedulingContextList] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingContextList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha2.PodSchedulingContext]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PodSchedulingContextList (
          items = items,
          metadata = metadata
        )
    }
}

