package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._


final case class MatchCondition(
  expression : String,
  name : String
) {

  /** Returns a new data with expression set to new value */
  def withExpression(value: String) : MatchCondition = copy(expression = value)
  /** transforms expression to result of function */
  def mapExpression(f: String => String) : MatchCondition = copy(expression = f(expression))

  /** Returns a new data with name set to new value */
  def withName(value: String) : MatchCondition = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : MatchCondition = copy(name = f(name))
}

object MatchCondition {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.MatchCondition] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.MatchCondition] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.MatchCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("expression", o.expression)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[MatchCondition] = new Decoder[MatchCondition] {
      def apply[T : Reader](t: T): Either[String, MatchCondition] = for {
          obj <- ObjectReader(t)
          expression <- obj.read[String]("expression")
          name <- obj.read[String]("name")
      } yield MatchCondition (
          expression = expression,
          name = name
        )
    }
}

