package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** NetworkPolicy describes what network traffic is allowed for a set of Pods */
final case class NetworkPolicy(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1.NetworkPolicySpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "NetworkPolicy", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : NetworkPolicy = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : NetworkPolicy = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1.NetworkPolicySpec) : NetworkPolicy = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1.NetworkPolicySpec => io.k8s.api.networking.v1.NetworkPolicySpec) : NetworkPolicy = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = NetworkPolicy.encoder.apply(this)
}

object NetworkPolicy {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.NetworkPolicy] = new Encoder[io.k8s.api.networking.v1.NetworkPolicy] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.NetworkPolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[NetworkPolicy] = new Decoder[NetworkPolicy] {
      def apply[T : Reader](t: T): Either[String, NetworkPolicy] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.networking.v1.NetworkPolicySpec]("spec")
      } yield NetworkPolicy (
          metadata = metadata,
          spec = spec
        )
    }
}

