package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** GroupSubject holds detailed information for group-kind subject. */
final case class GroupSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : GroupSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : GroupSubject = copy(name = f(name))
}

object GroupSubject {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.GroupSubject] = new Encoder[io.k8s.api.flowcontrol.v1beta3.GroupSubject] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.GroupSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[GroupSubject] = new Decoder[GroupSubject] {
      def apply[T : Reader](t: T): Either[String, GroupSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield GroupSubject (
          name = name
        )
    }
}

