package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** ValidationRule describes a validation rule written in the CEL expression language. */
final case class ValidationRule(
  rule : String,
  message : Option[String] = None,
  messageExpression : Option[String] = None
) {

  /** Returns a new data with rule set to new value */
  def withRule(value: String) : ValidationRule = copy(rule = value)
  /** transforms rule to result of function */
  def mapRule(f: String => String) : ValidationRule = copy(rule = f(rule))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ValidationRule = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ValidationRule = copy(message = message.map(f))

  /** Returns a new data with messageExpression set to new value */
  def withMessageExpression(value: String) : ValidationRule = copy(messageExpression = Some(value))
  /** if messageExpression has a value, transforms to the result of function*/
  def mapMessageExpression(f: String => String) : ValidationRule = copy(messageExpression = messageExpression.map(f))
}

object ValidationRule {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rule", o.rule)
            .write("message", o.message)
            .write("messageExpression", o.messageExpression)
            .build
        }
    }

    implicit val decoder: Decoder[ValidationRule] = new Decoder[ValidationRule] {
      def apply[T : Reader](t: T): Either[String, ValidationRule] = for {
          obj <- ObjectReader(t)
          rule <- obj.read[String]("rule")
          message <- obj.readOpt[String]("message")
          messageExpression <- obj.readOpt[String]("messageExpression")
      } yield ValidationRule (
          rule = rule,
          message = message,
          messageExpression = messageExpression
        )
    }
}

