package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy. */
final case class ValidatingAdmissionPolicyStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  observedGeneration : Option[Int] = None,
  typeChecking : Option[io.k8s.api.admissionregistration.v1alpha1.TypeChecking] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ValidatingAdmissionPolicyStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : ValidatingAdmissionPolicyStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ValidatingAdmissionPolicyStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : ValidatingAdmissionPolicyStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : ValidatingAdmissionPolicyStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with typeChecking set to new value */
  def withTypeChecking(value: io.k8s.api.admissionregistration.v1alpha1.TypeChecking) : ValidatingAdmissionPolicyStatus = copy(typeChecking = Some(value))
  /** if typeChecking has a value, transforms to the result of function*/
  def mapTypeChecking(f: io.k8s.api.admissionregistration.v1alpha1.TypeChecking => io.k8s.api.admissionregistration.v1alpha1.TypeChecking) : ValidatingAdmissionPolicyStatus = copy(typeChecking = typeChecking.map(f))
}

object ValidatingAdmissionPolicyStatus {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("observedGeneration", o.observedGeneration)
            .write("typeChecking", o.typeChecking)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyStatus] = new Decoder[ValidatingAdmissionPolicyStatus] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]("conditions")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          typeChecking <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.TypeChecking]("typeChecking")
      } yield ValidatingAdmissionPolicyStatus (
          conditions = conditions,
          observedGeneration = observedGeneration,
          typeChecking = typeChecking
        )
    }
}

