package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** APIServiceStatus contains derived information about an API server */
final case class APIServiceStatus(
  conditions : Option[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]] = None
) {
  def withConditions(value: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]) : APIServiceStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition*) : APIServiceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

}

